# This function accepts data and the maximum survey scale as input
# Create the direction vector and Magnitude vectors corrosponding to each response in the data
# Also Sends megnitude value and direction value as output
Pattern<-function(Dat,Scl)
{
  D_o = subset(Dat, select = -c(Group)) #eliminating "Group" attribute
  grp = subset(Dat, select = c(Group))  #Separate out "Group" attribute
  D = apply(D_o,2,as.numeric)
  X= dim(D)
  y = Scl
  d1=X[1]
  d2=X[2]
  bas=(y+1)/2 #mid value of maximum range
  G = matrix(data=0,nrow=d1,ncol=d2) #Direction Vector
  for(i in 1:d1)
  {
    for(j in d2:1)
    {
      p = ((d2+1)-j)
      q = j
      if(j==1) #first attribute
      {
        a = (D[i,j]-bas) # a is the directional difference between two attributes
      }
      else 
      {
        a = (D[i,j]-D[i,(j-1)]) # a is the directional difference between two attributes
      }
      if(a<0)
      {
        G[i,j]= -1 #negative direction
      }
      else
      {
        if(a==0)
        {
          G[i,j]= 0 #Constant direction
        }
        else
        {
          G[i,j] = 1 #Positive direction
          
        }
      }
    }
  }
  return(list(grp,D,G))
}